/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.Arrays;

public final class DefineData
implements DefineTag {
    private static final String FORMAT = "DefineData: { identifier=%d; data=byte<%d> ...}";
    private int identifier;
    private byte[] data;
    private transient int length;

    public DefineData(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        coder.readInt();
        this.data = coder.readBytes(new byte[this.length - coder.bytesRead()]);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineData(int uid, byte[] bytes) {
        this.setIdentifier(uid);
        this.setData(bytes);
    }

    public DefineData(DefineData object) {
        this.identifier = object.identifier;
        this.data = object.data;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DefineData copy() {
        return new DefineData(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 6 + this.data.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5631);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x15C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeInt(0);
        coder.writeBytes(this.data);
        coder.check(this.length);
        coder.unmark();
    }
}

