/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.Event;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.ActionData;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EventHandler
implements Action {
    private static final String FORMAT = "EventHandler: { events=%s; key=%s; actions=%s}";
    private static final int EVENTS_VERSION = 6;
    private static final int KEY_OFFSET = 9;
    private static final int KEY_MASK = 65024;
    private static final int EVENT_MASK = 511;
    private static final int NUM_BUTTON_EVENTS = 9;
    private static final int NUM_CLIP_EVENTS = 19;
    private static final int BIT0 = 1;
    private static final int BIT1 = 2;
    private static final int BIT2 = 4;
    private static final int BIT3 = 8;
    private static final int BIT4 = 16;
    private static final int BIT5 = 32;
    private static final int BIT6 = 64;
    private static final int BIT7 = 128;
    private static final int BIT8 = 256;
    private static final int BIT9 = 512;
    private static final int BIT10 = 1024;
    private static final int BIT11 = 2048;
    private static final int BIT12 = 4096;
    private static final int BIT13 = 8192;
    private static final int BIT14 = 16384;
    private static final int BIT15 = 32768;
    private static final int BIT16 = 65536;
    private static final int BIT17 = 131072;
    private static final int BIT18 = 262144;
    private static final Map<Event, Integer> CLIP_CODES = new LinkedHashMap<Event, Integer>();
    private static final Map<Event, Integer> BUTTON_CODES;
    private static final Map<Event, Integer> MENU_CODES;
    private static final Map<Integer, Event> CLIP_EVENTS;
    private static final Map<Integer, Event> BUTTON_EVENTS;
    private static final Map<Integer, Event> MENU_EVENTS;
    private Set<Event> events;
    private int key;
    private List<Action> actions;
    private transient int eventCode;
    private transient int length;
    private transient int offset;

    public EventHandler(int value, SWFDecoder coder, Context context) throws IOException {
        int field;
        this.events = EnumSet.noneOf(Event.class);
        if (context.contains(2) && context.get(2) == 34) {
            int i;
            this.length = value;
            int eventKey = coder.readUnsignedShort();
            this.eventCode = eventKey & 0x1FF;
            this.key = (eventKey & 0xFE00) >> 9;
            if (context.contains(18)) {
                for (i = 0; i < 9; ++i) {
                    field = this.eventCode & 1 << i;
                    if (!MENU_EVENTS.containsKey(field)) continue;
                    this.events.add(MENU_EVENTS.get(field));
                }
            } else {
                for (i = 0; i < 9; ++i) {
                    field = this.eventCode & 1 << i;
                    if (field == 0 || !BUTTON_EVENTS.containsKey(field)) continue;
                    this.events.add(BUTTON_EVENTS.get(field));
                }
            }
        } else {
            this.eventCode = value;
            this.length = coder.readInt();
            if ((this.eventCode & CLIP_CODES.get((Object)Event.KEY_PRESS)) != 0) {
                this.key = coder.readByte();
                --this.length;
            }
            for (int i = 0; i < 19; ++i) {
                field = this.eventCode & 1 << i;
                if (field == 0 || !CLIP_EVENTS.containsKey(field)) continue;
                this.events.add(CLIP_EVENTS.get(field));
            }
        }
        this.actions = new ArrayList<Action>();
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        if (decoder == null) {
            if (this.length != 0) {
                this.actions.add(new ActionData(coder.readBytes(new byte[this.length])));
            }
        } else {
            coder.mark();
            while (coder.bytesRead() < this.length) {
                decoder.getObject(this.actions, coder, context);
            }
            coder.unmark();
        }
    }

    public EventHandler(Set<Event> event, List<Action> list) {
        this.setEvents(event);
        this.setActions(list);
    }

    public EventHandler(Set<Event> event, int character, List<Action> list) {
        this.setEvents(event);
        this.setKey(character);
        this.setActions(list);
    }

    public EventHandler(EventHandler object) {
        this.events = object.events;
        this.key = object.key;
        this.actions = new ArrayList<Action>(object.actions);
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Set<Event> getEvents() {
        return this.events;
    }

    public void setEvents(Set<Event> set) {
        this.events = set;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int code) {
        this.key = code;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    public EventHandler add(Action anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException();
        }
        this.actions.add(anAction);
        return this;
    }

    @Override
    public EventHandler copy() {
        return new EventHandler(this);
    }

    public String toString() {
        return String.format(FORMAT, this.events, this.key, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.eventCode = 0;
        if (context.contains(2) && context.get(2) == 34) {
            if (context.contains(18)) {
                for (Event event : this.events) {
                    this.eventCode |= MENU_CODES.get((Object)event).intValue();
                }
            } else {
                for (Event event : this.events) {
                    this.eventCode |= BUTTON_CODES.get((Object)event).intValue();
                }
            }
            this.length = 4;
            for (Action action : this.actions) {
                this.length += action.prepareToEncode(context);
            }
            this.offset = context.contains(16) ? -2 : this.length - 2;
        } else {
            for (Event event : this.events) {
                this.eventCode |= CLIP_CODES.get((Object)event).intValue();
            }
            this.length = context.get(1) >= 6 ? 8 : 6;
            this.offset = (this.eventCode & CLIP_CODES.get((Object)Event.KEY_PRESS)) == 0 ? 0 : 1;
            for (Action action : this.actions) {
                this.offset += action.prepareToEncode(context);
            }
            this.length += this.offset;
        }
        return this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.mark();
        if (context.contains(2) && context.get(2) == 34) {
            coder.writeShort(this.offset + 2);
            coder.writeShort(this.key << 9 | this.eventCode);
        } else {
            if (context.get(1) >= 6) {
                coder.writeInt(this.eventCode);
            } else {
                coder.writeShort(this.eventCode);
            }
            coder.writeInt(this.offset);
            if ((this.eventCode & CLIP_CODES.get((Object)Event.KEY_PRESS)) != 0) {
                coder.writeByte(this.key);
            }
        }
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }

    static {
        CLIP_CODES.put(Event.LOAD, 1);
        CLIP_CODES.put(Event.ENTER_FRAME, 2);
        CLIP_CODES.put(Event.UNLOAD, 4);
        CLIP_CODES.put(Event.MOUSE_MOVE, 8);
        CLIP_CODES.put(Event.MOUSE_DOWN, 16);
        CLIP_CODES.put(Event.MOUSE_UP, 32);
        CLIP_CODES.put(Event.KEY_DOWN, 64);
        CLIP_CODES.put(Event.KEY_UP, 128);
        CLIP_CODES.put(Event.DATA, 256);
        CLIP_CODES.put(Event.INITIALIZE, 512);
        CLIP_CODES.put(Event.PRESS, 1024);
        CLIP_CODES.put(Event.RELEASE, 2048);
        CLIP_CODES.put(Event.RELEASE_OUT, 4096);
        CLIP_CODES.put(Event.ROLL_OVER, 8192);
        CLIP_CODES.put(Event.ROLL_OUT, 16384);
        CLIP_CODES.put(Event.DRAG_OVER, 32768);
        CLIP_CODES.put(Event.DRAG_OUT, 65536);
        CLIP_CODES.put(Event.KEY_PRESS, 131072);
        CLIP_CODES.put(Event.CONSTRUCT, 262144);
        CLIP_EVENTS = new LinkedHashMap<Integer, Event>();
        CLIP_EVENTS.put(1, Event.LOAD);
        CLIP_EVENTS.put(2, Event.ENTER_FRAME);
        CLIP_EVENTS.put(4, Event.UNLOAD);
        CLIP_EVENTS.put(8, Event.MOUSE_MOVE);
        CLIP_EVENTS.put(16, Event.MOUSE_DOWN);
        CLIP_EVENTS.put(32, Event.MOUSE_UP);
        CLIP_EVENTS.put(64, Event.KEY_DOWN);
        CLIP_EVENTS.put(128, Event.KEY_UP);
        CLIP_EVENTS.put(256, Event.DATA);
        CLIP_EVENTS.put(512, Event.INITIALIZE);
        CLIP_EVENTS.put(1024, Event.PRESS);
        CLIP_EVENTS.put(2048, Event.RELEASE);
        CLIP_EVENTS.put(4096, Event.RELEASE_OUT);
        CLIP_EVENTS.put(8192, Event.ROLL_OVER);
        CLIP_EVENTS.put(16384, Event.ROLL_OUT);
        CLIP_EVENTS.put(32768, Event.DRAG_OVER);
        CLIP_EVENTS.put(65536, Event.DRAG_OUT);
        CLIP_EVENTS.put(131072, Event.KEY_PRESS);
        CLIP_EVENTS.put(262144, Event.CONSTRUCT);
        BUTTON_CODES = new LinkedHashMap<Event, Integer>();
        BUTTON_CODES.put(Event.ROLL_OVER, 1);
        BUTTON_CODES.put(Event.ROLL_OUT, 2);
        BUTTON_CODES.put(Event.PRESS, 4);
        BUTTON_CODES.put(Event.RELEASE, 8);
        BUTTON_CODES.put(Event.DRAG_OUT, 16);
        BUTTON_CODES.put(Event.DRAG_OVER, 32);
        BUTTON_CODES.put(Event.RELEASE_OUT, 64);
        BUTTON_EVENTS = new LinkedHashMap<Integer, Event>();
        BUTTON_EVENTS.put(1, Event.ROLL_OVER);
        BUTTON_EVENTS.put(2, Event.ROLL_OUT);
        BUTTON_EVENTS.put(4, Event.PRESS);
        BUTTON_EVENTS.put(8, Event.RELEASE);
        BUTTON_EVENTS.put(16, Event.DRAG_OUT);
        BUTTON_EVENTS.put(32, Event.DRAG_OVER);
        BUTTON_EVENTS.put(64, Event.RELEASE_OUT);
        MENU_CODES = new LinkedHashMap<Event, Integer>();
        MENU_CODES.put(Event.ROLL_OVER, 1);
        MENU_CODES.put(Event.ROLL_OUT, 2);
        MENU_CODES.put(Event.PRESS, 4);
        MENU_CODES.put(Event.RELEASE, 8);
        MENU_CODES.put(Event.RELEASE_OUT, 16);
        MENU_CODES.put(Event.DRAG_OVER, 128);
        MENU_CODES.put(Event.DRAG_OUT, 256);
        MENU_EVENTS = new LinkedHashMap<Integer, Event>();
        MENU_EVENTS.put(1, Event.ROLL_OVER);
        MENU_EVENTS.put(2, Event.ROLL_OUT);
        MENU_EVENTS.put(4, Event.PRESS);
        MENU_EVENTS.put(8, Event.RELEASE);
        MENU_EVENTS.put(16, Event.RELEASE_OUT);
        MENU_EVENTS.put(128, Event.DRAG_OVER);
        MENU_EVENTS.put(256, Event.DRAG_OUT);
    }
}

