/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Import
implements MovieTag {
    private static final String FORMAT = "Import: { url=%s; objects=%s}";
    private String url;
    private Map<Integer, String> objects;
    private transient int length;

    public Import(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.url = coder.readString();
        int count = coder.readUnsignedShort();
        this.objects = new LinkedHashMap<Integer, String>(count);
        for (int i = 0; i < count; ++i) {
            this.objects.put(coder.readUnsignedShort(), coder.readString());
        }
        coder.check(this.length);
        coder.unmark();
    }

    public Import() {
        this.objects = new LinkedHashMap<Integer, String>();
    }

    public Import(String aUrl, Map<Integer, String> map) {
        this.setUrl(aUrl);
        this.objects = map;
    }

    public Import(Import object) {
        this.url = object.url;
        this.objects = new LinkedHashMap<Integer, String>(object.objects);
    }

    public Import add(int uid, String aString) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.objects.put(uid, aString);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<Integer, String> getObjects() {
        return this.objects;
    }

    public void setUrl(String aString) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.url = aString;
    }

    public void setObjects(Map<Integer, String> aTable) {
        this.objects = aTable;
    }

    @Override
    public Import copy() {
        return new Import(this);
    }

    public String toString() {
        return String.format(FORMAT, this.url, this.objects);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + context.strlen(this.url);
        for (Integer identifier : this.objects.keySet()) {
            this.length += 2 + context.strlen(this.objects.get(identifier));
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(3711);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xE40 | this.length);
        }
        coder.writeString(this.url);
        coder.writeShort(this.objects.size());
        for (Integer identifier : this.objects.keySet()) {
            coder.writeShort(identifier);
            coder.writeString(this.objects.get(identifier));
        }
    }
}

