/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import com.flagstone.transform.button.ButtonState;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Blend;
import com.flagstone.transform.datatype.ColorTransform;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.filter.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class ButtonShape
implements SWFEncodeable,
Copyable<ButtonShape> {
    private static final String FORMAT = "ButtonShape: { state=%d; identifier=%d; layer=%d; transform=%s; colorTransform=%s; blend=%s; filters=%s}";
    private int state;
    private int identifier;
    private int layer;
    private CoordTransform transform;
    private ColorTransform colorTransform;
    private List<Filter> filters;
    private Integer blend;
    private transient boolean hasBlend;
    private transient boolean hasFilters;

    public ButtonShape(SWFDecoder coder, Context context) throws IOException {
        int bits = coder.readByte();
        this.hasBlend = (bits & 0x20) != 0;
        this.hasFilters = (bits & 0x10) != 0;
        this.state = bits & 0xF;
        this.identifier = coder.readUnsignedShort();
        this.layer = coder.readUnsignedShort();
        this.transform = new CoordTransform(coder);
        if (context.get(2) != null && context.get(2) == 34) {
            this.colorTransform = new ColorTransform(coder, context);
        }
        if (this.hasFilters) {
            SWFFactory<Filter> decoder = context.getRegistry().getFilterDecoder();
            int count = coder.readByte();
            this.filters = new ArrayList<Filter>(count);
            for (int i = 0; i < count; ++i) {
                decoder.getObject(this.filters, coder, context);
            }
        } else {
            this.filters = new ArrayList<Filter>();
        }
        if (this.hasBlend) {
            this.blend = coder.readByte();
            if (this.blend == 0) {
                this.blend = 1;
            }
        } else {
            this.blend = 0;
        }
    }

    public ButtonShape() {
        this.transform = CoordTransform.translate(0, 0);
        this.colorTransform = new ColorTransform(0, 0, 0, 0);
        this.filters = new ArrayList<Filter>();
        this.blend = 0;
    }

    public ButtonShape(ButtonShape object) {
        this.state = object.state;
        this.identifier = object.identifier;
        this.layer = object.layer;
        this.transform = object.transform;
        this.colorTransform = object.colorTransform;
        this.filters = new ArrayList<Filter>(object.filters);
        this.blend = object.blend;
    }

    public Set<ButtonState> getState() {
        EnumSet<ButtonState> set = EnumSet.noneOf(ButtonState.class);
        if ((this.state & 1) != 0) {
            set.add(ButtonState.UP);
        }
        if ((this.state & 2) != 0) {
            set.add(ButtonState.OVER);
        }
        if ((this.state & 4) != 0) {
            set.add(ButtonState.DOWN);
        }
        if ((this.state & 8) != 0) {
            set.add(ButtonState.ACTIVE);
        }
        return set;
    }

    public ButtonShape setState(Set<ButtonState> states) {
        block6: for (ButtonState buttonState : states) {
            switch (buttonState) {
                case UP: {
                    this.state |= 1;
                    continue block6;
                }
                case OVER: {
                    this.state |= 2;
                    continue block6;
                }
                case DOWN: {
                    this.state |= 4;
                    continue block6;
                }
                case ACTIVE: {
                    this.state |= 8;
                    continue block6;
                }
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public ButtonShape addState(ButtonState buttonState) {
        switch (buttonState) {
            case UP: {
                this.state |= 1;
                break;
            }
            case OVER: {
                this.state |= 2;
                break;
            }
            case DOWN: {
                this.state |= 4;
                break;
            }
            case ACTIVE: {
                this.state |= 8;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public ButtonShape setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
        return this;
    }

    public int getLayer() {
        return this.layer;
    }

    public ButtonShape setLayer(int aNumber) {
        if (aNumber < 1 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.layer = aNumber;
        return this;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public ButtonShape setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
        return this;
    }

    public ColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public ButtonShape setColorTransform(ColorTransform cxform) {
        if (cxform == null) {
            throw new IllegalArgumentException();
        }
        this.colorTransform = cxform;
        return this;
    }

    public ButtonShape add(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        this.filters.add(filter);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public ButtonShape setFilters(List<Filter> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.filters = list;
        return this;
    }

    public Blend getBlend() {
        return Blend.fromInt(this.blend);
    }

    public ButtonShape setBlend(Blend mode) {
        this.blend = mode.getValue();
        return this;
    }

    @Override
    public ButtonShape copy() {
        return new ButtonShape(this);
    }

    public String toString() {
        return String.format(FORMAT, this.state, this.identifier, this.layer, this.transform, this.colorTransform, this.blend, this.filters);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.hasBlend = this.blend.intValue() != Blend.NULL.getValue();
        this.hasFilters = true ^ this.filters.isEmpty();
        int length = 5 + this.transform.prepareToEncode(context);
        if (context.get(2) != null && context.get(2) == 34) {
            length += this.colorTransform.prepareToEncode(context);
        }
        if (this.hasFilters) {
            ++length;
            for (Filter filter : this.filters) {
                length += filter.prepareToEncode(context);
            }
        }
        if (this.hasBlend) {
            ++length;
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        int bits = 0;
        bits |= this.hasBlend ? 32 : 0;
        bits |= this.hasFilters ? 16 : 0;
        coder.writeByte(bits |= this.state);
        coder.writeShort(this.identifier);
        coder.writeShort(this.layer);
        this.transform.encode(coder, context);
        if (context.get(2) != null && context.get(2) == 34) {
            this.colorTransform.encode(coder, context);
        }
        if (this.hasFilters) {
            coder.writeByte(this.filters.size());
            for (Filter filter : this.filters) {
                filter.encode(coder, context);
            }
        }
        if (this.hasBlend) {
            coder.writeByte(this.blend);
        }
    }
}

