/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.filter;

import com.flagstone.transform.coder.CoderException;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.filter.BevelFilter;
import com.flagstone.transform.filter.BlurFilter;
import com.flagstone.transform.filter.ColorMatrixFilter;
import com.flagstone.transform.filter.ConvolutionFilter;
import com.flagstone.transform.filter.DropShadowFilter;
import com.flagstone.transform.filter.Filter;
import com.flagstone.transform.filter.GlowFilter;
import com.flagstone.transform.filter.GradientBevelFilter;
import com.flagstone.transform.filter.GradientGlowFilter;
import java.io.IOException;
import java.util.List;

public final class FilterDecoder
implements SWFFactory<Filter> {
    @Override
    public void getObject(List<Filter> list, SWFDecoder coder, Context context) throws IOException {
        Filter filter;
        int type = coder.readByte();
        switch (type) {
            case 0: {
                filter = new DropShadowFilter(coder, context);
                break;
            }
            case 1: {
                filter = new BlurFilter(coder);
                break;
            }
            case 2: {
                filter = new GlowFilter(coder, context);
                break;
            }
            case 3: {
                filter = new BevelFilter(coder, context);
                break;
            }
            case 4: {
                filter = new GradientGlowFilter(coder, context);
                break;
            }
            case 5: {
                filter = new ConvolutionFilter(coder, context);
                break;
            }
            case 6: {
                filter = new ColorMatrixFilter(coder);
                break;
            }
            case 7: {
                filter = new GradientBevelFilter(coder, context);
                break;
            }
            default: {
                throw new CoderException(coder.mark(), "Unsupported Filter: " + type);
            }
        }
        list.add(filter);
    }
}

