/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageInfo;
import com.flagstone.transform.util.image.ImageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.DataFormatException;

public final class ImageFactory {
    private transient ImageDecoder decoder;

    public void read(File file) throws IOException, DataFormatException {
        ImageInfo info = new ImageInfo();
        info.setInput(new RandomAccessFile(file, "r"));
        if (!info.check()) {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder = ImageRegistry.getImageProvider(info.getImageFormat().getMimeType());
        this.decoder.read(new FileInputStream(file));
    }

    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        String mimeType = connection.getContentType();
        this.decoder = ImageRegistry.getImageProvider(mimeType);
        if (this.decoder == null) {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder.read(url.openStream());
    }

    public void read(InputStream stream) throws IOException, DataFormatException {
        this.decoder.read(stream);
    }

    public ImageTag defineImage(int identifier) {
        return this.decoder.defineImage(identifier);
    }

    public ImageDecoder getDecoder() {
        return this.decoder;
    }
}

