/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.sound.DefineSound;
import com.flagstone.transform.util.sound.SoundDecoder;
import com.flagstone.transform.util.sound.SoundRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.DataFormatException;

public final class SoundFactory {
    private transient SoundDecoder decoder;

    public void read(File file) throws IOException, DataFormatException {
        String mimeType;
        if (file.getName().endsWith("wav")) {
            mimeType = "audio/x-wav";
        } else if (file.getName().endsWith("mp3")) {
            mimeType = "audio/mpeg";
        } else {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder = SoundRegistry.getSoundProvider(mimeType);
        this.decoder.read(new FileInputStream(file));
    }

    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        String mimeType = connection.getContentType();
        this.decoder = SoundRegistry.getSoundProvider(mimeType);
        if (this.decoder == null) {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder.read(url.openStream());
    }

    public void read(InputStream stream) throws IOException, DataFormatException {
        this.decoder.read(stream);
    }

    public DefineSound defineSound(int identifier) throws IOException, DataFormatException {
        return this.decoder.defineSound(identifier);
    }

    public DefineSound defineSound(int identifier, float duration) throws IOException, DataFormatException {
        return this.decoder.defineSound(identifier, duration);
    }

    public MovieTag streamHeader(float frameRate) {
        return this.decoder.streamHeader(frameRate);
    }

    public MovieTag streamSound() throws IOException, DataFormatException {
        return this.decoder.streamSound();
    }
}

